import pandas as pd   
import pickle
from decision_company import read_csv_file, count_unique_values, bind_dataframe, pivot_a_level, fill_missing_values

# Load the dataset  
credit_customers = read_csv_file("credit_customers.csv")  

# Calculate approval rates  
credit_history_group = bind_dataframe(credit_customers, 'credit_history')  
credit_history_counts = count_unique_values(credit_history_group['class'], normalize=True)  
approval_rates_credit_history = fill_missing_values(pivot_a_level(credit_history_counts), value=0)['good']    

print(approval_rates_credit_history)
pickle.dump(approval_rates_credit_history,open("./ref_result/approval_rates_credit_history.pkl","wb"))

  